struct Vert{
    vec4 pos;
    vec4 color;
//    vec4 width;
    float width;
    bool constant_size;
    int transforms_buff_idx;
    vec4 bitan;
};

//uniform Vert* vert_buff;
//uniform mat4* transforms_buff;

layout(std430, binding = 12) buffer aaaGGG {
    Vert[] vert_buff;
};

layout(std430, binding = 10) buffer ggafffsdg {
    mat4[] transforms_buff;
};

out vec3 out_pos;
out vec4 color;
out int vert_id;

void main() {
    vert_id = gl_VertexID/6;
    vert_id *= 2;
    int sub_tri_id = (gl_VertexID/3) % 2;
    int sub_vert_id = gl_VertexID % 3;

    int next_vert_id = vert_id + 1;
    //    int next_next_vert_id = vert_id + 2;
//    vec3 prev_vert_pos = vert_buff[max(vert_id-1,0)].pos.xyz;
    vec3 curr_vert_pos = vert_buff[vert_id].pos.xyz;
    float curr_vert_width = vert_buff[vert_id].width;
    vec4 curr_col = vert_buff[vert_id].color;
    bool is_const_size = vert_buff[vert_id].constant_size;
    vec3 next_vert_pos = vert_buff[next_vert_id].pos.xyz;
    vec4 next_col = vert_buff[next_vert_id].color;
    


    //    vec3 next_next_vert_pos = vert_buff[next_next_vert_id].pos.xyz;
    
    int trans_idx_curr = vert_buff[vert_id].transforms_buff_idx;
    int trans_idx_next = vert_buff[next_vert_id].transforms_buff_idx;
    
    mat4 trans_curr = trans_idx_curr >= 0 ? transforms_buff[trans_idx_curr] : mat4(1);
    mat4 trans_next = trans_idx_next >= 0 ? transforms_buff[trans_idx_next] : mat4(1);
    

//    vec4 prev_vert_proj = P * V * vec4(prev_vert_pos,1);


    vec4 curr_vert_proj = V * trans_curr * vec4(curr_vert_pos,1);
    vec4 next_vert_proj = V * trans_next * vec4(next_vert_pos,1);
    

    float depth_a = curr_vert_proj.z;
    float depth_b = next_vert_proj.z;
    curr_vert_proj = P * curr_vert_proj;
    next_vert_proj = P * next_vert_proj;

    vec3 curr_vert_ndc = curr_vert_proj.xyz / curr_vert_proj.w;
    vec3 next_vert_ndc = next_vert_proj.xyz / next_vert_proj.w;
    
    
    vec2 curr_norm = vert_buff[vert_id].bitan.xy;


    vec2 l_w = R.x < R.y ? vec2(R.y/R.x,1) : vec2(1.0f, R.x/R.y);
    
    vec2 curr_tan = normalize((next_vert_ndc.xy - curr_vert_ndc.xy)/l_w);
    curr_norm = vec2(curr_tan.y, -curr_tan.x);

//    vec2 l_w = vec2(1.0f, R.x/R.y);
    curr_norm *= l_w;
    curr_norm *= curr_vert_width;

    vec2 offs_a = curr_norm;
    vec2 offs_b = curr_norm;

    if(!is_const_size){
        offs_a /= depth_a;
        offs_b /= depth_b;
    }
    
    vec2 v_A_0_ndc = curr_vert_ndc.xy + offs_a;
    vec2 v_A_1_ndc = curr_vert_ndc.xy - offs_a;

    vec2 v_B_0_ndc = next_vert_ndc.xy - offs_b;
    vec2 v_B_1_ndc = next_vert_ndc.xy + offs_b;


    vec4 v_A_0 = vec4(v_A_0_ndc * curr_vert_proj.w, curr_vert_proj.zw);
    vec4 v_A_1 = vec4(v_A_1_ndc * curr_vert_proj.w, curr_vert_proj.zw);
    vec4 v_B_0 = vec4(v_B_0_ndc * next_vert_proj.w, next_vert_proj.zw);
    vec4 v_B_1 = vec4(v_B_1_ndc * next_vert_proj.w, next_vert_proj.zw);

    vec4 pp;
    if(sub_tri_id == 0){
        if(sub_vert_id == 0){
            pp = v_A_0;
            color = curr_col;
        } else if(sub_vert_id == 1) {
            pp = v_B_0;
            color = next_col;
        } else {
            pp = v_A_1;
            color = curr_col;
        }
    } else {
        if(sub_vert_id == 0){
            pp = v_A_0;
            color = curr_col;
        } else if(sub_vert_id == 1) {
            pp = v_B_1;
            color = next_col;
        } else {
            pp = v_B_0;
            color = next_col;
        }
    }
    
    const vec4 voffs = vec4(0,0,0.000,0);
    const vec4 sc = vec4(vec3(1.,1.,1.)*0.9999,1);
    pp -= voffs;
    pp *= sc;

    gl_Position = pp;
}
